<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:template match="/">
	<html>
		<head>
			<link rel="stylesheet" type="text/css" href="../js/mnlstyle.css"/>
			<script language='JavaScript'>
				var _naviname = _getBrowserName();
				function _getBrowserName() {
					var str = navigator.appName.toUpperCase();
					if (str.indexOf("NETSCAPE") >= 0) return ("NS");
					if (str.indexOf("EXPLORER") >= 0) return ("IE");
					return ("UNKNOWN");
				}
				function _getBrowserLang() {
					if (_naviname == "IE") {
						//return navigator.browserLanguage;
						//return navigator.systemLanguage;
						return navigator.userLanguage;
					} else if (_naviname == "NS"){
						return navigator.language.split("-")[0];
					}
				}
				function load() {
					if (_getBrowserLang() == 'ja') {
						document.getElementById("p1").innerHTML = "部品番号";
						document.getElementById("p2").innerHTML = "部品名称";
						document.getElementById("p3").innerHTML = "ノート";
						document.getElementById("p4").innerHTML = "ブロック図";
						document.getElementById("p5").innerHTML = "端子機能";
						document.getElementById("t1").innerHTML = "端子No.";
						document.getElementById("t2").innerHTML = "ラベル";
						document.getElementById("t3").innerHTML = "入出力";
						document.getElementById("t4").innerHTML = "備考";
					}
					if (_naviname == "IE") {
						var svgDoc= document.getElementById("svg1").getSVGDocument();
						var svgObj = svgDoc.getDocumentElement();
						var vbox = svgObj.getAttribute('viewBox');
						vbox = vbox.split(" ");
						if (vbox[2] > document.body.clientWidth * 1/1.5 - 20) {
							document.svg1.style.width = document.body.clientWidth - 20;
							document.svg1.style.height = ((document.body.clientWidth - 20) / vbox[2] * vbox[3]);
						} else {
							document.svg1.style.width = vbox[2] * 1.5;
							document.svg1.style.height = vbox[3] * 1.5;
						}
						document.svg1.DefaultAntialias = "0";
					}
				}
			</script>
		</head>
		<xsl:element name="body"> 
			<xsl:if test="//BLOCKFIG[. != ''] and contains(//BLOCKFIG,'.svgz')">
				<xsl:attribute name="onLoad">load();</xsl:attribute>
				<xsl:attribute name="onResize">load();</xsl:attribute>
			</xsl:if>
			<table width="100%">
				<tr>
					<td width="100" align="left"><b><span id="p1">Part No</span></b></td>
					<td><xsl:value-of select="//PARTNO"/></td>
				</tr>
				<tr>
					<td width="100" align="left"><b><span id="p2">Information</span></b></td>
					<td><xsl:value-of select="//INFO"/></td>
				</tr>
				<tr>
					<td width="100" align="left"><b><span id="p3">Note</span></b></td>
					<td><xsl:value-of select="//NOTE"/></td>
				</tr>
				<xsl:if test="//BLOCKFIG[. != '']"> 
					<tr>
						<td width="100" align="left" nowrap="nowrap"><b><span id="p4">Block Diagram</span></b></td>
						<td></td>
					</tr>
				</xsl:if>
			</table>
			<xsl:if test="//BLOCKFIG[. != '']"> 
				<p align="center">
				<xsl:if test="contains(//BLOCKFIG,'.svgz')">
					<embed align="middle" width="100%" heght="100%">
						<xsl:attribute name="src"><xsl:value-of select="//BLOCKFIG"/></xsl:attribute>
						<xsl:attribute name="name">svg1</xsl:attribute>
						<xsl:attribute name="id">svg1</xsl:attribute>
					</embed>
				</xsl:if>
				<xsl:if test="contains(//BLOCKFIG,'.png') or contains(//BLOCKFIG,'.gif') or contains(//BLOCKFIG,'.bmp')">
					<img align="middle">
						<xsl:attribute name="src"><xsl:value-of select="//BLOCKFIG"/></xsl:attribute>
					</img>
				</xsl:if>
				</p>
			</xsl:if>
			<b><span id="p5">Pin Function</span></b><br/>
			<table width='100%' border='1'>
				<tr>
					<th><span id="t1">Pin</span></th>
					<th><span id="t2">Label</span></th>
					<th><span id="t3">I/O</span></th>
					<th><span id="t4">Description</span></th>
				</tr>
				<xsl:apply-templates select="/ICTABLE/ROW">
					<xsl:sort select="ID" order="ascending"/>
				</xsl:apply-templates>
			</table>
		</xsl:element> 
	</html>
</xsl:template>

<xsl:template match="/ICTABLE/ROW">
	<tr> 
		<td align="center" nowrap="nowrap">
			<xsl:if test="PINNO[. != '']"><xsl:call-template name="text"><xsl:with-param name="content"><xsl:value-of select="PINNO"/></xsl:with-param></xsl:call-template></xsl:if>
			<xsl:if test="PINNO[. = '']"><br/></xsl:if>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="LABEL[. != '']"><xsl:call-template name="text"><xsl:with-param name="content"><xsl:value-of select="LABEL"/></xsl:with-param></xsl:call-template></xsl:if>
			<xsl:if test="LABEL[. = '']"><br/></xsl:if>
		</td>
		<td align="center" nowrap="nowrap">
			<xsl:if test="IO[. != '']"><xsl:call-template name="text"><xsl:with-param name="content"><xsl:value-of select="IO"/></xsl:with-param></xsl:call-template></xsl:if>
			<xsl:if test="IO[. = '']"><br/></xsl:if>
		</td>
		<td>
			<xsl:if test="DESCRIPTION[. != '']"><xsl:call-template name="text"><xsl:with-param name="content"><xsl:value-of select="DESCRIPTION"/></xsl:with-param></xsl:call-template></xsl:if>
			<xsl:if test="DESCRIPTION[. = '']"><br/></xsl:if>
		</td>
	</tr>
</xsl:template>

<xsl:template name="text">
	<xsl:param name="content" select="."/>
	<xsl:value-of select="substring-before($content, '&#10;')"/>
	<xsl:choose>
		<xsl:when test="contains($content, '&#10;')">
			<br/>
			<xsl:call-template name="text">
				<xsl:with-param name="content" select="substring-after($content, '&#10;')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="string-length($content) &gt; 0">
			<xsl:value-of select="$content"/>
		</xsl:when>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>
